capture log close
clear all
macro drop _all
cd "C:\Users\alice\OneDrive\Alice QUANTONOMICS\Residuals Analysis - Output Weights\ABR25 - 2006-2024"
set more off
log using OutWeights-Outliers, replace text


/*--------------------------------------------------------------------------
Project: Output Weights - Residuals Outliers
Author:  Alice Giovani
File:    OutWeights-Outliers.do
Initial Date:    22Sep2025
Revised Date:  	 25Sep2025
--------------------------------------------------------------------------*/


import excel "LeonCostResults-DNSP25ei-24", clear ///
	sheet("fulldata") cellrange(A1:AN248) firstrow case(l)

sort dnsp year

label define dnsplabel 1 "EVO" 2 "AGD" 3 "CIT" 4 "END" 5 "ENX" 6 "ERG" 7 "ESS" ///
	8 "JEN" 9 "PCR" 10 "SAP" 11 "AND" 12 "TND" 13 "UED"
label values dnsp dnsplabel

gen res1 = x1-hx1
gen res2 = x2-hx2
gen res3 = x3-hx3
gen res4 = x4-hx4

keep dnsp year x1 x2 x3 x4 res1 res2 res3 res4 hx1 hx2 hx3 hx4

*Standardised Residuals

foreach v in res1 res2 res3 res4 {
    by dnsp: egen z_`v' = std(`v')   // standardised residual by dnsp
	list dnsp year `v' z_`v' if abs(z_`v')>3
	}
	
*Boxplots 
foreach v in res1 res2 res3 res4 {
    graph box `v', over(dnsp, label(angle(90))) ///
    ytitle("Residual") 
    graph export "box_`v'_dnsp.png", replace width(2000)
	graph drop _all
}


forvalues i = 1/13 {
    forvalues k = 1/4 {
        
        twoway ///
            (scatter x`k' year if dnsp==`i', msymbol(o) mcolor(red)) ///
            (line hx`k' year if dnsp==`i', lcolor(black) lwidth(thin)), ///
             xtitle("Year") ///
			 xlabel(2006(1)2024, angle(90)) ///
            legend(off) 
            graph export "x`k'_dnsp`i'.png", replace width(2000)
    }
}

*Extremes
foreach v in res1 res2 res3 res4 {
    by dnsp, sort: extremes `v'
}

	
log close
exit
